//=============================================================================
// NanoBolt.
//=============================================================================
class AcidMold extends Projectile;

var Actor Moldee;
var int CurTicks;
var int TotalTicks;

#exec OBJ LOAD FILE=Effects
#exec OBJ LOAD FILE=MSBorderFX

state Fading
{
 function BeginState()
 {
  Style = STY_Translucent;
  ScaleGlow = 2.500000;
 }

 function Tick(float DT)
 {
  Scaleglow -= DT;
  
  if (Scaleglow <= 0.000000)
  {
   Destroy();
  }
 }
}

function PostBeginPlay()
{
 Super.PostBeginPlay();
 
 SetCollision(False, False, False);
 SetTimer(0.05, True);
}

function Timer()
{
 if (Moldee != None)
 {

  //Mesh = Moldee.Mesh;
  DrawScale = Moldee.DrawScale + 0.050000;
  SetLocation(Moldee.Location);
  SetRotation(Moldee.Rotation);

  CurTicks++;

  if (CurTicks >= 4)
  {
   TotalTicks++;
   CurTicks = 0;
   if (!Moldee.Isa('Decoration') || int(Moldee.GetPropertyText("hitPoints")) > 0) Moldee.TakeDamage(1, Pawn(Owner), vect(0,0,0), vect(0,0,0), 'Acid');
  }

  AnimSequence = Moldee.AnimSequence;
  AnimFrame = Moldee.AnimFrame;
  AnimRate = Moldee.AnimRate;
  TweenRate = Moldee.TweenRate;
 }
 
 if (Moldee == None || TotalTicks > 20)
 {
  GoToState('Fading');
 }
 
}

defaultproperties
{
     Style=STY_Translucent
     Multiskins(0)=FireTexture'AcidTile'
     Multiskins(1)=FireTexture'AcidTile'
     Multiskins(2)=FireTexture'AcidTile'
     Multiskins(3)=FireTexture'AcidTile'
     Multiskins(4)=FireTexture'AcidTile'
     Multiskins(5)=FireTexture'AcidTile'
     Multiskins(6)=FireTexture'AcidTile'
     Multiskins(7)=FireTexture'AcidTile'
     Texture=FireTexture'AcidTile'
     Skin=FireTexture'AcidTile'
}
